unit uSchUpdater;
{
---------------------------------------------------------------
Code generated by AF Component Wizard
AF Component Wizard 2002 AFComponents - Ferruccio Accalai
Idea by MAS-CompMaker, 2000-2002 Mats Asplund http://go.to/mdp
---------------------------------------------------------------

Component Name: TSchUpdater
        Author: Snuki
 Creation Date: 2006.01.29.
       Version: 1.3
   Description: Simple application self-updater
        E-mail: snuki@freemail.hu
       Website: - none -
  Legal Issues: All rigths reserved 1996-2005 by Snuki
  Thanks for help to:
    A.Falanga (a.falanga@gmail.com)
    bsalsa (bsalsa@bsalsa.no-ip.info)


Usage:
  1: Fill the SourceDir directory (wathever if exists ending '\' or not)
  2: Call DoUpdate function (result: true=OK, false=failed)

Properties:
  - AutoRestartApp: boolean
    if you want to restart your application automatically after update
    then set it True, otherwise false.
    Recommended leave it True.
  - Language: TSchSimpleUpdaterLanguage
    English, Hungarian, French
    You can add other languages, jast add it to TSchSimpleUpdaterLanguage,
    and change the content of ErrorHandle procedure
  - OtherFiles: TStringList
    (Ignore the duplicates and case insensitive)
    If you want to update not just exe, then add to here the other filenames
    (without path). You can use the AddOtherFile procedure or OtherFiles.Add method.
  - SaveDir: string
    If you checked the SaveOriginalFiles, then DoUpdate save all of exists files
    (exe and OtherFiles) to the %SAVEDIR%\%YYYYMMDDHHMMSS% directory.
    If SaveDir is empty and you checked the SaveOriginalFiles then SaveDir default
    is %APPDIR%\PRGBACKUP\%YYYYMMDDHHMMSS% directory.
  - SaveOriginalFiles: boolean;
    If you want to save the original files before update, then set it true.
  - StopOnFirstError: boolean
    If you want to stop the update procedure on the first dir create or copy error,
    then set it true.
    See error list in TSchSimpleUpdaterError.
  - UpdateSrc: string
    You have to set this property. This is the directory of new updated files
    (the source). Wathever if exists ending '\' or not.

Event:
  - OnError(Sender: TObject; ErrorCode: TSchSimpleUpdaterError;
                    Parameter, ErrMessage: string);
    All of procedure messages have sent to this event. In the Parameter
    you get the file or directory name if it's.

Procedures/functions:
  - AddOtherFile(OtherFileName: string): Integer;
    Add OtherFileName to the OtherFiles, if is not empty.
  - DoUpdate: Boolean
    Let's go!


  Sorry, because my english is'n very well.


  This software is provided 'as-is', without any express or
  implied warranty.  In no event will the author be held liable
  for any  damages arising from the use of this software.

  Permission is granted to anyone to use this software for any
  purpose, including commercial applications, and to alter it
  and redistribute it freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented,
     you must not claim that you wrote the original software.
     If you use this software in a product, an acknowledgment
     in the product documentation would be appreciated but is
     not required.

  2. Altered source versions must be plainly marked as such, and
     must not be misrepresented as being the original software.

  3. This notice may not be removed or altered from any source
     distribution.

  4. If you decide to use this software in any of your applications.
     Send me an EMail and tell me about it.


---------------------------------------------------------------
}

interface

uses
  SysUtils, Classes, Forms, Windows, Messages;

type
  TSchSimpleUpdaterError = (suecNeedRestartApp, suecNoEXESourceDir,
                            suecNoEXESource, suecNoOtherSource,
                            suecCannotCreateSaveDir,
                            suecFileCopyError, suecAlreadyUpdated,
                            suecEmptySourceDir);
  TSchSimpleUpdaterLanguage = (sulaEnglish, sulaHungarian,sulaFrench);

  TOnError = procedure(Sender: TObject; ErrorCode: TSchSimpleUpdaterError;
                       Parameter, ErrMessage: string) of object;

  TSchUpdater = class(TComponent)
  private
    { Private declarations }
    fOnError           : TOnError;
    fAbout             : String;
    fLanguage          : TSchSimpleUpdaterLanguage;
    fUpdateSrc         : string;
    fOtherFiles        : TStringList;
    fStopOnFirstError  : Boolean;
    fSaveOriginalFiles : Boolean;
    fSaveDir           : string;
    fAutoRestartApp    : Boolean;
    fUpdated           : Boolean;
    procedure SetAbout(Value: string);
  protected
    { Protected declarations }
    procedure ErrorHandler(pErrCode : TSchSimpleUpdaterError; Parameter: string = '');
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function AddOtherFile(OtherFileName: string): Integer;
    procedure SetOtherFiles(Value: TstringList);    
    function DoUpdate: Boolean;
  published
    { Published declarations }
    property OnError: TOnError read fOnError write fOnError;
    property Language : TSchSimpleUpdaterLanguage read fLanguage write fLanguage default sulaEnglish;
    property UpdateSrc: string read fUpdateSrc write fUpdateSrc;
    property StopOnFirstError: Boolean read fStopOnFirstError write fStopOnFirstError default False;
    property SaveOriginalFiles: Boolean read fSaveOriginalFiles write fSaveOriginalFiles default False;
    property SaveDir: string read fSaveDir write fSaveDir;
    property AutoRestartApp: Boolean read fAutoRestartApp write fAutoRestartApp default True;
    property OtherFiles: TStringList read fOtherFiles write SetOtherFiles;
    property About: String read fAbout write SetAbout;
  end;

procedure Register;

implementation

procedure Register;
begin
   RegisterComponents('Snuki', [TSchUpdater]);
end;

constructor TSchUpdater.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	fAbout    := 'Version 1.1, 1996-2005 Snuki';
  fUpdated:=False;
  fOtherFiles:= TStringList.Create;
  fOtherFiles.CaseSensitive:=False;
  fOtherFiles.Duplicates:=dupIgnore;
  fAutoRestartApp:=True;
  fSaveDir:='';
  fSaveOriginalFiles:=False;
  fStopOnFirstError:=False;
  fUpdateSrc:='';
end;

destructor TSchUpdater.Destroy;
begin
  fOtherFiles.Free;
	inherited Destroy;
end;

procedure TSchUpdater.SetAbout(Value: string);
begin
  exit;
end;

procedure TSchUpdater.ErrorHandler(pErrCode: TSchSimpleUpdaterError; Parameter: string);
var
  sErrorMessage: string;
begin
  case fLanguage of
    sulaEnglish: case pErrCode of
      suecNeedRestartApp         : sErrorMessage:='Update is done! Please restart Your application!';
      suecNoEXESourceDir         : sErrorMessage:='Not exist the directory of update source!';
      suecNoEXESource            : sErrorMessage:='Not exist the update source (application)!';
      suecCannotCreateSaveDir    : sErrorMessage:='Can''t create the save directory!';
      suecNoOtherSource          : sErrorMessage:='Not exist some of other files in directory of update source!';
      suecFileCopyError          : sErrorMessage:='File copy error!';
      suecAlreadyUpdated         : sErrorMessage:='Files already updated!';
      suecEmptySourceDir         : sErrorMessage:='Source directory not defined!';
    end;
    sulaHungarian: case pErrCode of
      suecNeedRestartApp         : sErrorMessage:='A frissts megtrtnt! Indtsa jra az alkalmazst!';
      suecNoEXESourceDir         : sErrorMessage:='Nem ltezik a frissts helyeknt megadott knyvtr!';
      suecNoEXESource            : sErrorMessage:='Nem tallhat a friss alkalmazs a forrs knyvtrban!';
      suecCannotCreateSaveDir    : sErrorMessage:='A mentsi knyvtr nem hozhat ltre!';
      suecNoOtherSource          : sErrorMessage:='Nem tallhat a fjl a forrs knyvtrban!';
      suecFileCopyError          : sErrorMessage:='Hiba a fjl msolsa kzben!';
      suecAlreadyUpdated         : sErrorMessage:='A frissts mr megtrtnt!';
      suecEmptySourceDir         : sErrorMessage:='A frissts forrs knyvtra nincs megadva!';
    end;
    sulaFrench : case pErrCode of
      suecNeedRestartApp         : sErrorMessage:='Mise  jour effectue ! Veuillez redmarrer votre application!';
      suecNoEXESourceDir         : sErrorMessage:='Le directory pour la mise  jour n''existe pas !';
      suecNoEXESource            : sErrorMessage:='Le directory pour la mise  jour n''existe pas (application)!';
      suecCannotCreateSaveDir    : sErrorMessage:='Ne peut crer le rpertore pour la sauvegarde !';
      suecNoOtherSource          : sErrorMessage:='Certains fichiers n''existe pas dans le rpertoire de mise  jour!';
      suecFileCopyError          : sErrorMessage:='Erreur lors de la copie des fichiers !';
      suecAlreadyUpdated         : sErrorMessage:='Fichier dja  jour!';
      suecEmptySourceDir         : sErrorMessage:='Le rpertoire source n''est pas dfini !';
    end;
  end;
  if Assigned(FOnError) then FOnError(Self, pErrCode, Parameter, sErrorMessage);
end;

function TSchUpdater.AddOtherFile(OtherFileName: string): Integer;
begin
  Result:=-1;
  if Trim(OtherFileName)<>''
    then Result:=fOtherFiles.Add(OtherFileName);
end;

function TSchUpdater.DoUpdate: Boolean;
var
  iTemp: Integer;
  sExeName: string;
  sBatFileName: string;
  slBat: TStringList;
  pi: TProcessInformation;
  si: TStartupInfo;
  sDirActual : string;
  sLocalBackup : string;
begin
  Result:=False;

  // If update process run before then exit with error
  if fUpdated then
  begin
    ErrorHandler(suecAlreadyUpdated);
    exit;
  end;

  if Trim(fUpdateSrc)='' then
  begin
    ErrorHandler(suecEmptySourceDir);
    exit;
  end;

  {$WARN SYMBOL_PLATFORM OFF}
  // EXE filename                         : sExeName                           .
  sExeName:=ExtractFileName(Application.ExeName);

  // Directory of fresh files             : sUpdateSrc                         .
  fUpdateSrc:=IncludeTrailingBackslash(fUpdateSrc);

  // Directory of running application     : sDirActual                         .
  sDirActual:=IncludeTrailingBackslash(UpperCase(ExtractFilePath(Application.ExeName)));

  // Save old files to here               : fSaveDir                           .
  // Common save directory
  if Trim(fSaveDir)=''
    then fSaveDir:=sDirActual+'PRGBACKUP\'
    else fSaveDir:=IncludeTrailingBackslash(fSaveDir);

  // Check exist of source directory
  if not(DirectoryExists(fUpdateSrc)) then
  begin
    ErrorHandler(suecNoEXESourceDir);
    if fStopOnFirstError then exit;
  end;

  // Check exist of source EXE
  if not(FileExists(fUpdateSrc+sExeName)) then
  begin                                                
    ErrorHandler(suecNoEXESource);
    if fStopOnFirstError then exit;
  end;

  // Create common save dir, if not exist
  // A.Falanga - 06/12/05 modification in order to create nothing (no directory)
  // if the SaveOriginalFiles property is set to FALSE
  if fSaveOriginalFiles then
    if not(DirectoryExists(fSaveDir)) then
      if not(CreateDir(fSaveDir)) then
      begin
        ErrorHandler(suecCannotCreateSaveDir, fSaveDir);
        if fStopOnFirstError then exit;
      end;

  // Now, create the actually save dir
  fSaveDir:= fSaveDir+FormatDateTime('yyyyMMddHHmmss',Now)+'\';

  if fSaveOriginalFiles then
  // A.Falanga - 06/12/05 modification in order to create nothing (no directory)
  // if the SaveOriginalFiles property is set to FALSE
    if not CreateDir(fSaveDir) then
    begin
      ErrorHandler(suecCannotCreateSaveDir, fSaveDir);
      if fStopOnFirstError then exit;
    end;

  // Save EXE (local backup)
  sLocalBackup:=sDirActual+'B'+sExeName;
  if not(CopyFile(PAnsiChar(Application.ExeName),
                  PAnsiChar(sLocalBackup),False)) then
  begin
    ErrorHandler(suecFileCopyError, sExeName);
    if fStopOnFirstError then exit;
  end;

  // Save current files, if need
  if fSaveOriginalFiles and DirectoryExists(fSaveDir) then
  begin
    // Save EXE
    if not(CopyFile(PAnsiChar(Application.ExeName),
                    PAnsiChar(fSaveDir+sExeName),False)) then
    begin
      ErrorHandler(suecFileCopyError, sExeName);
      if fStopOnFirstError then exit;
    end;


    // Save existing other files
    for iTemp:=0 to fOtherFiles.Count-1 do
    begin
      if FileExists(sDirActual+fOtherFiles[iTemp]) then
      begin
        if not(CopyFile(PAnsiChar(sDirActual+fOtherFiles[iTemp]),
                        PAnsiChar(fSaveDir+fOtherFiles[iTemp]),False)) then
        begin
          ErrorHandler(suecFileCopyError, fOtherFiles[iTemp]);
          if fStopOnFirstError then exit;
        end;
      end;
    end;
  end;

  // Copy new EXE
  if not(CopyFile(PAnsiChar(fUpdateSrc+sExeName),
                  PAnsiChar(sDirActual+'_'+sExeName),False)) then
  begin
    ErrorHandler(suecFileCopyError, '_'+sExeName);
    if fStopOnFirstError then exit;
  end;


  // Copy existing other files
  for iTemp:=0 to fOtherFiles.Count-1 do
  begin
    if FileExists(fUpdateSrc+fOtherFiles[iTemp]) then
    begin
      if not(CopyFile(PAnsiChar(fUpdateSrc+fOtherFiles[iTemp]),
                      PAnsiChar(sDirActual+'_'+fOtherFiles[iTemp]),False)) then
      begin
        ErrorHandler(suecFileCopyError, '_'+fOtherFiles[iTemp]);
        if fStopOnFirstError then exit;
      end;
    end;
  end;

  sBatFileName:=ChangeFileExt(Application.ExeName,'.bat');
  slBat:=TStringList.Create;
  slBat.Add('@Echo Off');
  slBat.Add(':again');
  // Delete EXE:                                                               .
  slBat.Add('del "' + Application.ExeName + '"');
  // If can't do it then again:                                                .
  slBat.Add('if exist "' + Application.ExeName + '" goto again');
  // Rename the new version EXE:                                               .
  slBat.Add('copy "' + sDirActual+'_'+sExeName + '" "' + Application.ExeName + '"');
  slBat.Add('del "' + sDirActual+'_'+sExeName + '"');
  // Rename other files                                                        .
  for iTemp:=0 to fOtherFiles.Count-1 do
  begin
    if FileExists(sDirActual + '_' + fOtherFiles[iTemp]) then
    begin
      slBat.Add('copy "' + sDirActual + '_' + fOtherFiles[iTemp] + '" "' +
                           sDirActual + fOtherFiles[iTemp] + '"');
      slBat.Add('del "' + sDirActual + '_' + fOtherFiles[iTemp] + '"');
    end;
  end;
  // If done then finish:                                                      .
  slBat.Add('if exist "' + Application.ExeName + '" goto finish');
  // If not exist the EXE then copy back from local backup:                    .
  slBat.Add('copy "' + sLocalBackup + '" "' + Application.ExeName + '"');
  slBat.Add(':finish');
  // Delete local backup file
  slBat.Add('del "' + sLocalBackup + '"');
  // Restarting EXE:                                                           .
  if fAutoRestartApp
    then slBat.Add('call "' + Application.ExeName + '"');
  // Delete this batch file:                                                   .
  slBat.Add('del "' + sBatFileName + '"');
  slBat.SaveToFile(sBatFileName);
  slBat.Free;

  // Create a hidden process for execute the batch file
  FillChar(si, SizeOf(TStartupInfo), 0);
  si.dwFlags:=STARTF_USESHOWWINDOW;
  si.wShowWindow:=SW_HIDE;

  if CreateProcess(nil, PChar(sBatFileName), nil, nil, False,
                   IDLE_PRIORITY_CLASS, nil, nil, si, pi) then
  begin
    CloseHandle(pi.hThread);
    CloseHandle(pi.hProcess);
  end;

  fUpdated:=True;
  Result:=True;

  // Restart app if need
  if fAutoRestartApp
    then PostMessage(Application.Handle, WM_CLOSE, 0, 0)
    else ErrorHandler(suecNeedRestartApp);
  {$WARN SYMBOL_PLATFORM ON}
end;

procedure TSchUpdater.SetOtherFiles(Value: TstringList);
begin
  fOtherFiles.Assign(Value);
end;

end.
