unit uSchTaskQueue;
{
---------------------------------------------------------------
Code generated by AF Component Wizard
AF Component Wizard 2002 AFComponents - Ferruccio Accalai
Idea by MAS-CompMaker, 2000-2002 Mats Asplund http://go.to/mdp
---------------------------------------------------------------

Component Name: TSchTaskQueue
        Author: Snuki
 Creation Date: 2005.12.08.
       Version: 1.0
   Description: Simple queue component for doing task in order
        E-mail: snuki@freemail.hu
       Website: - none -
  Legal Issues: All rigths reserved 1996-2005 by Snuki


Usage:
  Just add the tasks and call StartTask method.
  The component begin the work while any task is exist.
  Every task have name and ID (TSchTaskInfo).
  If begin a task, then OnNextTask event occured.
  When the task is finished, then will be removed from the task list,
  and start the next.

  See the sample source for more info.

  This software is provided 'as-is', without any express or
  implied warranty.  In no event will the author be held liable
  for any  damages arising from the use of this software.

  Permission is granted to anyone to use this software for any
  purpose, including commercial applications, and to alter it
  and redistribute it freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented,
     you must not claim that you wrote the original software.
     If you use this software in a product, an acknowledgment
     in the product documentation would be appreciated but is
     not required.

  2. Altered source versions must be plainly marked as such, and
     must not be misrepresented as being the original software.

  3. This notice may not be removed or altered from any source
     distribution.

  4. If you decide to use this software in any of your applications.
     Send me an EMail and tell me about it.


---------------------------------------------------------------
}

interface

uses
  SysUtils, Classes;

type
  TSchTaskQueueState = (stqsAddedTask, stqsClearTasks,
                        stqsInProgress, stqsNotInProgress,
                        stqsTaskStart, stqsTaskFinish, stqsEmptyTask);
  TSchTaskInfo = class
    Name      : string;
    ID        : integer;
  end;

  TOnNextTask     = procedure(Sender: TObject; Task: TSchTaskInfo) of object;
  TOnStateChange  = procedure(Sender: TObject; State: TSchTaskQueueState) of object;
  TOnEmpty        = procedure(Sender: TObject) of object;
  TOnActiveChange = procedure(Sender: TObject; Active: boolean) of object;

  TSchTaskQueue = class(TComponent)
  private
    { Private declarations }
    fOnNextTask : TOnNextTask;
    fOnStateChange : TOnStateChange;
    fOnEmpty    : TOnEmpty;
    fOnActiveChange: TOnActiveChange;
    fAbout: String;
    fTaskList : TStringList;
    fActive   : Boolean;
    fInProgress : Boolean;
    fDoClear : Boolean;
    procedure SetAbout(Value: string);
    procedure SetActive(const Value: Boolean);
    procedure DoNext;
    procedure DoStart;
    procedure DoStop;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property TaskList: TStringList read fTaskList;
    procedure ClearTaskList;
    function AddTask(TaskName: string; TaskId:integer): integer;
    function GetTaskCount: Integer;
    procedure StartTasks;
    procedure StopTasks;
  published
    { Published declarations }
    property OnNextTask: TOnNextTask read fOnNextTask write fOnNextTask;
    property OnStateChange: TOnStateChange read fOnStateChange write fOnStateChange;
    property OnEmpty: TOnEmpty read fOnEmpty write fOnEmpty;
    property OnActiveChange : TOnActiveChange read fOnActiveChange write fOnActiveChange;
    property Active : Boolean read fActive write SetActive default False;
    property InProgress : Boolean read fInProgress default False;
    property About: String read fAbout write SetAbout;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Snuki', [TSchTaskQueue]);
end;

constructor TSchTaskQueue.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);
	fAbout    := 'Version 1.0, 1996-2005 Snuki';
  fActive:=False;
  fInProgress:=False;
  fDoClear:=False;
  fTaskList:= TStringList.Create;
end;

destructor TSchTaskQueue.Destroy;
begin
  fTaskList.Free;
	inherited Destroy;
end;

procedure TSchTaskQueue.SetAbout(Value: string);
begin
  exit;
end;

function TSchTaskQueue.AddTask(TaskName: string; TaskId: integer): integer;
var
  ob : TSchTaskInfo;
begin
  Result:=-1;
  if TaskName='' then exit;
  ob:=TSchTaskInfo.Create;
  ob.Name:=TaskName;
  ob.ID:=TaskId;
  Result:=fTaskList.AddObject(TaskName,TObject(ob));
  if Assigned(fOnStateChange) then fOnStateChange(Self, stqsAddedTask);
end;

procedure TSchTaskQueue.ClearTaskList;
begin
  fDoClear:=True;
  if not(fInProgress) then
  begin
    fDoClear:=False;
    fTaskList.Clear;
  end;
  if Assigned(fOnStateChange) then fOnStateChange(Self, stqsClearTasks);
end;

function TSchTaskQueue.GetTaskCount: Integer;
begin
  Result:=fTaskList.Count;
end;

procedure TSchTaskQueue.SetActive(const Value: Boolean);
begin
  if fActive <> Value then
  begin
    fActive := Value;
    if Assigned(fOnActiveChange) then fOnActiveChange(Self, fActive);
  end;
  if fActive
    then DoStart
    else DoStop;
end;

procedure TSchTaskQueue.DoNext;
var
  stTemp: TSchTaskInfo;
begin
  if not(fActive) then exit;
  if fInProgress then exit;
  if fTaskList.Count=0 then exit;
  fInProgress:=True;
  if Assigned(fOnStateChange) then fOnStateChange(Self, stqsInProgress);
  while fTaskList.Count>0 do
  begin
    stTemp:=TSchTaskInfo(fTaskList.Objects[0]);
    if Assigned(fOnStateChange) then fOnStateChange(Self, stqsTaskStart);

    // Perform the current task
    if Assigned(fOnNextTask) then fOnNextTask(Self, stTemp);

    fTaskList.Delete(0);

    if Assigned(fOnStateChange) then fOnStateChange(Self, stqsTaskFinish);

    if not(fActive) or fDoClear then
    begin
      if fDoClear then fTaskList.Clear;
      fDoClear:=False;
      fInProgress:=False;
      if Assigned(fOnStateChange) then fOnStateChange(Self, stqsNotInProgress);
      if fTaskList.Count=0 then
      begin
        if Assigned(fOnStateChange) then fOnStateChange(Self, stqsEmptyTask);
        if Assigned(fOnEmpty) then fOnEmpty(Self);
        DoStop;
      end;
      exit;
    end;
  end;

  if fTaskList.Count=0 then
  begin
    fInProgress:=False;
    if Assigned(fOnStateChange) then fOnStateChange(Self, stqsNotInProgress);
    if Assigned(fOnStateChange) then fOnStateChange(Self, stqsEmptyTask);
    if Assigned(fOnEmpty) then fOnEmpty(Self);
    DoStop;
  end;
end;

procedure TSchTaskQueue.StartTasks;
begin
  DoStart;
end;

procedure TSchTaskQueue.StopTasks;
begin
  DoStop;
end;

procedure TSchTaskQueue.DoStart;
begin
  if fTaskList.Count=0 then exit;
//  if fInProgress then exit;
  if fActive <> True then
  begin
    fActive := True;
    if Assigned(fOnActiveChange) then fOnActiveChange(Self, fActive);
  end;
  DoNext;
end;

procedure TSchTaskQueue.DoStop;
begin
  if fActive <> False then
  begin
    fActive := False;
    if Assigned(fOnActiveChange) then fOnActiveChange(Self, fActive);
  end;
end;

end.
