unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uSchTaskQueue, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    SchTaskQueue1: TSchTaskQueue;
    mTasks: TMemo;
    mLog: TMemo;
    spl1: TSplitter;
    p1: TPanel;
    btnAddTasks: TButton;
    cbActive: TCheckBox;
    tmr1: TTimer;
    btnClearTasks: TButton;
    lTaskCount: TLabel;
    btnStart: TButton;
    btnStop: TButton;
    procedure FormCreate(Sender: TObject);
    procedure SchTaskQueue1StateChange(Sender: TObject;
      State: TSchTaskQueueState);
    procedure cbActiveClick(Sender: TObject);
    procedure SchTaskQueue1NextTask(Sender: TObject; Task: TSchTaskInfo);
    procedure SchTaskQueue1Empty(Sender: TObject);
    procedure btnAddTasksClick(Sender: TObject);
    procedure tmr1Timer(Sender: TObject);
    procedure btnClearTasksClick(Sender: TObject);
    procedure SchTaskQueue1ActiveChange(Sender: TObject; Active: Boolean);
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
  private
    { Private declarations }
    iGlobalCount : Integer;
    iCounter     : Integer;
    procedure SampleTask1;
    procedure SampleTask2;
    procedure SampleTask3;
    procedure SampleTask4;
    procedure SampleTask5;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  iGlobalCount:=0;
  iCounter:=0;
  mTasks.Lines.Clear;
  mLog.Lines.Clear;
  lTaskCount.Caption:='Task count: '+IntToStr(SchTaskQueue1.GetTaskCount);
end;

procedure TForm1.SchTaskQueue1StateChange(Sender: TObject;
  State: TSchTaskQueueState);
var
  sLog: string;
begin
  sLog:='OnStateChange: ';
  case State of
    stqsTaskStart     : sLog:=sLog+'stqsTaskStart';
    stqsTaskFinish    : sLog:=sLog+'stqsTaskFinish';
    stqsEmptyTask     : sLog:=sLog+'stqsEmptyTask';
    stqsAddedTask     : sLog:=sLog+'stqsAddedTask';
    stqsClearTasks    : sLog:=sLog+'stqsClearTasks';
    stqsInProgress    : sLog:=sLog+'stqsInProgress';
    stqsNotInProgress : sLog:=sLog+'stqsNotInProgress';
  end;
  mLog.Lines.Add(sLog);
  lTaskCount.Caption:='Task count: '+IntToStr(SchTaskQueue1.GetTaskCount);
  mTasks.Lines.Assign(SchTaskQueue1.TaskList);
end;

procedure TForm1.cbActiveClick(Sender: TObject);
begin
  SchTaskQueue1.Active:=cbActive.Checked;
end;

procedure TForm1.SchTaskQueue1NextTask(Sender: TObject;
  Task: TSchTaskInfo);
begin
  mLog.Lines.Add('OnNextTask: '+Task.Name+' ('+IntToStr(Task.ID)+')');
  case Task.ID of
    1: SampleTask1;
    2: SampleTask2;
    3: SampleTask3;
    4: SampleTask4;
    5: SampleTask5;
  end;
end;

procedure TForm1.SchTaskQueue1Empty(Sender: TObject);
begin
  mLog.Lines.Add('OnEmpty');
end;

procedure TForm1.btnAddTasksClick(Sender: TObject);
var
  iTemp: Integer;
begin
  for iTemp := 1 to 5 do
  begin
    Inc(iGlobalCount);
    SchTaskQueue1.AddTask('Task'+IntToStr(iGlobalCount),iTemp);
  end;
  mTasks.Lines.Assign(SchTaskQueue1.TaskList);
end;

procedure TForm1.tmr1Timer(Sender: TObject);
begin
  Inc(iCounter);
  mLog.Lines.Add('  TimerCounter: '+IntToStr(iCounter));
  if iCounter>=5 then tmr1.Enabled:=False;
end;

procedure TForm1.SampleTask1;
begin
  mLog.Lines.Add('SampleTask1');
  iCounter:=0;
  tmr1.Enabled:=True;
  repeat
    Application.ProcessMessages;
  until not(tmr1.Enabled);
end;

procedure TForm1.SampleTask2;
begin
  mLog.Lines.Add('SampleTask2');
  iCounter:=0;
  tmr1.Enabled:=True;
  repeat
    Application.ProcessMessages;
  until not(tmr1.Enabled);
end;

procedure TForm1.SampleTask3;
begin
  mLog.Lines.Add('SampleTask3');
  iCounter:=0;
  tmr1.Enabled:=True;
  repeat
    Application.ProcessMessages;
  until not(tmr1.Enabled);
end;

procedure TForm1.SampleTask4;
begin
  mLog.Lines.Add('SampleTask4');
  iCounter:=0;
  tmr1.Enabled:=True;
  repeat
    Application.ProcessMessages;
  until not(tmr1.Enabled);
end;

procedure TForm1.SampleTask5;
begin
  mLog.Lines.Add('SampleTask5');
  iCounter:=0;
  tmr1.Enabled:=True;
  repeat
    Application.ProcessMessages;
  until not(tmr1.Enabled);
end;

procedure TForm1.btnClearTasksClick(Sender: TObject);
begin
  SchTaskQueue1.ClearTaskList;
end;

procedure TForm1.SchTaskQueue1ActiveChange(Sender: TObject;
  Active: Boolean);
begin
  cbActive.Checked:=Active;
end;

procedure TForm1.btnStartClick(Sender: TObject);
begin
  SchTaskQueue1.StartTasks;
end;

procedure TForm1.btnStopClick(Sender: TObject);
begin
  SchTaskQueue1.StopTasks;
end;

end.
